﻿//============================================
// filename: main.c
// chip    : CSU38F20
// author  :
// date    : 2020-12-07
//============================================
#include "CSU38F20.h"
#include "timer2.h"

//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{
	if(TM2IF && TM2IE)
	{
		TM2IF = 0;
		PT1_0 = ~PT1_0;
	}
}

//============================================
// program start
//============================================
void main()
{
	unsigned char mode = 0;
	GIE = 0;
	timer2_init();	//时钟为cpuclk/32，62.5KHz
	PWM2STALL = 0;	//ICD调试stall（例如单步）时，定时器2单端PWM输出低电平，此配置取决于外围硬件情况，用于在芯片调试暂停时保护外围硬件不会受损
	switch(mode)
	{
		case 0:		//计数器模式
		{
			PT1EN_0 = 1;	//PT1.0为数字输出口，无上拉
			PT1PU_0 = 0;
			PT1CON = 0;
			PT1_0 = 0;
			
			T2OUT = 0;		//不做PWM/蜂鸣器输出
			PWM2OUT = 0;
			
			timer2_set_pwm_period(TIMER2_COUNT);	//4ms溢出一次
		}break;
		
		case 1:		//普通PWM模式
		{		
			PT5EN_0 = 1;	//PT5.0为PWM2输出口,数字输出口，无上拉
			PT5PU_0 = 0;
			PT3CON_0 = 0;
			
			T2OUT = 0;		//PWM2输出
			PWM2OUT = 1;
			PWM2PO = 0;
			
			timer2_set_pwm_period(TIMER2_COUNT);	//频率为250Hz
			timer2_set_pwm_duty(TIMER2_PWM_DUTY_50);	//占空比为50%
		}break;
		
		case 2:		//蜂鸣器模式
		{
			PT5EN_0 = 1;	//PT5.0为蜂鸣器输出口,数字输出口，无上拉
			PT5PU_0 = 0;
			PT5CON_0 = 0;
			
			T2OUT = 1;		//蜂鸣器输出
			PWM2OUT = 0;
			PWM2PO = 0;
			
			T2RATE_0 = 0;
			T2RATE_1 = 0;
			T2RATE_2 = 1;
			T2RATE_3 = 1;	//时钟修改为MCK/16，2MHz
			
			timer2_set_pwm_period(TIMER2_COUNT);	//4KHz，占空比50%
		}break;

		default:mode = 0;
	}
	timer2_count_clr();		//清零计数器
	timer2_enable();	//使能定时器2
	timer2_int_enable();	//使能定时器2中断
	while(1);
}
